# Changelog

## Mystique 2.13.0


### Added

- Updated operate API version to 2.0 and added a new operate commmand to get the current api version. (MO-188)
- Added new operate API commands and buttons to turn on and off all markers. (M0-99, MO-104)
- Added a new operate API command and button to display black on all projectors. (MO-123)
- Added a new operate API command to retrieve the status and current progress of a scene. (MO-124)
- Added the ability to see progress updates of the run in the operate UI as a calibration is running, for all workflows except Cinema. (MO-125, MO-157)
- Added a way to see the last successful run time and last approved run time (when applicable) in the operate UI. (MO-175) 
- Added a new operate API command to run all scenes consecutively in the operate configuration. (MO-120)
- Added a new operate API command to cancel a run all scenes operation. (MO-121) 
- Added a new operate API command to get the scene status summary of the run all scenes operation. (MO-151)
- Added a new dropdown option in the operate UI that will reveal new UI for the new run all scenes operations listed above. (MO-106)
- Added the option to increase the Solver Fit Order up to 6. (MI-10213)
- Added the Solver Fit Order option to the Essentials license tier. (MI-10213)
- Added support for Korus series projectors. (MI-10470)


### Changed

- Improved blend performance when combined with electronic color convergence. (MI-10311)
- Updated the required firmware for Christie M RGB Series to version 1.3.8. (MI-10366)
- Changed calibrations to now fail when camera calibration fails. (MI-10123, MO-90)
- Changed the screen test pattern button to be disabled until a successful calibration has been done. (MI-10200)
- Improved performance by no longer having cameras take pictures of patterns they cannot see. (MI-10210)
- Improved performance when moving camera calibration points in the UI. (MI-9614)
- Improved handling and error messaging of malformed model files. (MI-10061)
- Improved performance of loading model files. (MI-10092)
- Improved warp accuracy. (MI-10282, MI-10283, MI-10213)
- Improvements to operate UI text wrapping. (MO-147, MO-115)
- Changed all operate API commands to no longer default to scene 0 when scene selection is unspecified. (MO-136)
- Test patterns options for 2D calibrations are now saved to file and restored on re-opening. (MI-10216)
- Renamed the operate 'Clear' button and API command to 'Show Content'. (MO-152)
- Changed the operate settings configuration list to start at 0 instead of 1. (MO-146)
- Changed all projector drawing buttons to have consistent functionality when projectors are off or shuttered. (MI-9523)
- Changed guardian calibrations to now fail when guardian warp validation fails. (MI-10363)
- Changed the operate UI to use the word Configuration instead of Scene. (MO-176)
- Changed the operate cancel API to return an error when attempting to cancel a scene that does not exist. (MO-156)
- Removing or deleting the associated twist file now clears any saved twist data for the Mystique calibration. (MI-10361)
- Improved clarification when changes are saved to the operate settings in the UI. (MO-98)
- Changed the default Solver Fit Order from 3 to 4. (MI-10213)
- Renamed the 'Send Blends' checkbox to 'Use Blends'. (MI-10446)


### Fixed

- Fixed an issue where cropping with a cropping distance of 0 would make the model and points disappear. (MI-9332)
- Fixed operate actions not completing when a dongle upgrade key existed on the license dongle. (MI-7388)
- Fixed 3D automation controller calibrations not clearing the point cloud. (MI-9910)
- Fixed the identity test pattern button not being disabled when the projector is disconnected. (MI-9996)
- Fixed an issue with blend masks having unintended artifacts for certain configurations. (MI-9902)
- Fixed an issue where a camera may use the incorrect exposure during parallel gather. (MI-9609)
- Fixed an issue where auto exposure error messages not being sent over to operate correctly. (MI-7853)
- Fixed issues with calibration error messages not being sent over to operate correctly. (MO-95, MI-9408, MI-10256)
- Fixed a crash during locate. (MI-9813)
- Fixed an issue where adding malformed model files to Mystique would create malformed twist files. (MI-10060)
- Fixed an error message showing twice when attempting to move calibration points that cannot be moved. (MI-9280)
- Fixed operate not getting notified when device connection is lost during a calibration. (MO-66)
- Fixed an issue with some html text showing in error messages sent over to operate. (MI-10289)
- Fixed an issue where the operate UI would not update correctly when the scene selection is changed. (MO-173)
- Fixed an issue where the send to operate button would be enabled before the calibration file has been saved. (MI-10340)
- Fixed an issue where old calibration files would open with invalid exposure minimums and maximums. (MI-10401)
- Fixed an issue where a blend from a previous run could be displayed when 'Send Blends' was unchecked. (MI-10446)


### Removed

- Removed the approve and restore buttons in the operate UI for 3D and Cinema configurations. (MO-100)
- Removed the Blends Only test pattern button. (MI-10339)

## Mystique 2.12.0


### Added

- Added support for fisheye camera lenses in all license tiers except Cinema. (MI-9677)
- Added Manual Warp Adjustment in all 2D workflows except Cinema and Lite. (MI-9883)
- Added support for the Sapphire 4K40-RGBH projector. (MI-9969, MI-9997)
- Added support for Jazz series projectors. (MI-9689)
- Added functionality to carry-over Mystique Operate configuration to future versions. (MO-85)
- Added a button to upload the Marked Surface Image to all projectors for alignment verification. (MI-9784)
- Added automatic collapsing functionality to the journal. (MI-8071)
- Added a prompt in Lite to power up and unshutter projectors which are off before a run. (MI-8974)


### Changed

- Changed required firmware version for Griffyn series and Christie M RGB series projectors. (MI-9913)
- Improved performance of 3D edge reduction blending. (MI-10016)
- Improved error reporting when attempting to load with unsupported cameras offline. (MI-10052)
- Improved error reporting when attempting to load with DALSA cameras when driver is not installed. (MI-9750)
- Improved error message when attempting to upgrade a dongle without administrative privileges. (MI-9342)
- Changed Camera Calibration in 3D to also reset solved projector positions. (MI-9871)
- Reduced memory utilization during 3D Gather. (MI-9800)
- Reduced journal clutter when saving projector solves to MPCDI. (MI-9648)
- Changed precision displayed for pixel aspect ratio in 2D layouts. (MI-9828)
- Changed 3D gather pattern defaults for higher resolution projectors. (MI-9966)
- Changed interface text for use masks from Twist file option to include all masks from Twist. (MI-9930)
- Improved Single Shot Gather (beta) stability. (MI-9128)
- Updated to Sapera LT 8.73 for Teledyne DALSA Cameras. (MI-9541)
- Improved application stability when saving information during an alignment. (MI-10091)


### Fixed

- Fixed an issue causing CineLife projectors to lose connection to Mystique Operate. (MO-93)
- Fixed "Calibrate Cameras" appearing at the wrong level of the journal. (MI-10152)
- Fixed some test patterns in projector control causing the alignment pattern to be shown after a run. (MI-10151)
- Fixed copying from a table would add extra columns when pasting into external applications. (MI-10120)
- Fixed an issue where the initial test pattern state of Cinema projectors would not be restored. (MI-10106)
- Fixed an issue where some license dongles were not working. (MI-9911)
- Fixed an issue with being unable to draw the 3D Test Pattern when using custom output channel resolutions. (MI-9934)
- Fixed camera preview thresholding mode causing some cameras to appear disconnected. (MI-10096)
- Fixed loading a second PCD file hiding the point cloud in system view.  (MI-10065)
- Fixed an issue which caused Brightness Uniformity adjustments to be overwritten when using the option to automatically mask to screen. (MI-9929)
- Fixed Black Level Blending checkbox label not being disabled when the checkbox is disabled. (MI-9821)
- Fixed an issue where invalid marker numbers were sometimes found during automation controller camera calibrations. (MI-9773)
- Fixed an issue where the camera preview in Lite would sometimes be off-center. (MI-9690)
- Fixed an issue where the 3D test pattern progress window would be empty. (MI-9674)
- Fixed a measured screen error message to appearing when it should not. (MI-9644)
- Fixed units of system memory in log. (MI-9592)
- Fixed an issue with CIC cameras not retaining ambient exposure. (MI-9348)
- Fixed a file name sometimes showing in Lite. (MI-9346)
- Fixed output channel resolutions not being maintained when a projector is replaced. (MI-9325)
- Fixed the Journal not automatically scrolling in some situations. (MI-8905)
- Fixed output channel sometimes sharing the same output for multiple projectors. (MI-7428)
- Fixed slow load times and crashes with large models with UV mappings in 3D. (MI-10165)
- Fixed a crash when replacing a disconnected CIC cameras. (MI-9397)
- Fixed a crash when attempting to use invalid paths to PCD or OBJ files. (MI-8795)
- Fixed an issue where custom camera masking would not be used with runs triggered through Mystique Operate. (MI-9956)
- Fixed an issue where drawing test patterns through Mystique Operate for 2D workflows would not complete. (MO-71)


### Removed

- Removed CTRL+R as a shortcut to start a run. (MI-9663)


## Mystique 2.11.2


### Added

- Added support for the Sapphire 4K40-RGBH projector. (MI-9969, MI-9997)


### Fixed

- Fixed an issue where some license dongles were not working. (MI-9911)
- Fixed an issue with being unable to draw the 3D Test Pattern when using custom output channel resolutions. (MI-9934) 
- Fixed an issue where the initial test pattern state of Cinema projectors would not be restored. (MI-10106)


## Mystique 2.11.1


### Fixed

- Fixed an issue where custom camera masking would not be used with runs triggered through Mystique Operate. (MI-9956)


## Mystique 2.11.0


### Added

- Added the ability to use Single Shot Automatic Exposure (beta). (MI-8353)
- Added a button to display the Single Shot Automatic Exposure Pattern (beta). (MI-9574)
- Added the ability to use Single Shot Gather (beta). (MI-7342)
- Added a button to display the Single Shot Gather Pattern (beta). (MI-7344)
- Added user feedback when loading an invalid screen model in 3D workflows. (MI-9485)
- Added Rest/JSON Operate API documentation to the installation folder. (MI-9444)
- Added the ability to maintain the camera name after a camera replace. (MI-9443)
- Added projector firmware version logging. (MI-9414)
- Added system load logging. (MI-9396)
- Added a copy of the marked surface image to diagnostics. (MI-9264)
- Added an image of the 2D gather validation test pattern to diagnostics. (MI-8782)
- Added the projector MAC address to projector details. (MI-8591)
- Added the ability to reorder cameras in the UI. (MI-5582)
- Added the Operate version number to the Operate webpages. (MO-79)


### Changed

- Improved license information logging. (MI-9399)
- Increased the maximum camera capture time to one second. (MI-9565)
- Improved image processing for better results when using colored test patterns. (MI-9521)
- Updated system requirements in the documentation. (MI-9494)
- Improved PNG writing performance. (MI-9434)
- Updated instructions for writing the MPCDI file to a network location. (MI-9409)
- Changed the color of the projector IP address to be more visible in dark mode. (MI-9403)
- Improved camera masking performance. (MI-9363)
- Improved Channel Width/Height input validation and tooltips. (MI-9344)
- Improved gather progress messages. (MI-9228)
- Improved webcam image capture perfomance. (MI-9039)
- Improved error message for connection issues during cinema alignments. (MI-8893)
- Changed Operate version number to now be the same as Mystique. (MO-77)
- Increased minimum command timeout of cinema projectors. (MI-9701)
- Improved camera stability by reducing network contention. (MI-9766)


### Fixed

- Fixed an issue where calibrations using a fisheye projector lens would not complete when ran with Mystique Operate. (MI-9638)
- Addressed a crash when closing Mystique when Guardian is enabled. (MI-9655)
- Fixed an issue where license dongles would not work. (MI-9603)
- Fixed an issue where changing the exposure of a Teledyne Dalsa Genie Nano camera was reporting failures in the logs. (MI-9569)
- Fixed an issue where the identify test pattern would draw incorrectly on some resolutions. (MI-9550)
- Addressed a crash when using the camera preview sharpness slider. (MI-9508)
- Addressed a crash when drawing the 3D wireframe test pattern through Operate. (MI-9502)
- Fixed an issue with excessive logging when using pandoras box outputs. (MI-9426)
- Fixed an issue where clicking a camera in the camera calibration table no longer auto selected that cameras preview and calibration table. (MI-9456)
- Fixed an issue where cinema autofocus would not find a good focus. (MI-9421)
- Addressed a crash that happened when the system runs out of memory/disk space. (MI-9379, MI-9335)
- Addressed a crash when removing a camera. (MI-9321)
- Fixed an issue where copying or saving camera preview images would not work. (MI-9316)
- Fixed an issue where switching preview layouts was changing the preview zoom level. (MI-9312)
- Fixed an issue where changing test patterns of many projectors at once was causing the UI to hang. (MI-9281)
- Addressed a crash when changing electronic convergence options after the camera has been removed. (MI-9141)
- Fixed an issue causing alignment failures while using high contrast mode and parallel gather. (MI-9046)
- Fixed an issue where cameras were listed as UNKNOWN in Mystique Lite. (MI-8987)
- Fixed an issue causing intermittent camera capture failures during cinema autofocus or electronic convergence runs. (MI-8405)
- Fixed an issue that showed the wrong Operate version number in Operate. (M0-81)
- Fixed an issue with incorrect filenames reported by the projector. (MI-9700)

### Removed

- Removed Windows 8 as a supported operating system in the documentation. (MI-9495)


## Mystique 2.10.0


### Added

- Added the ability to do a partial gather with a subset of projectors in Mystique 3D. (MI-8788)
- Added a warning the Black Level % is set to less than the Tint %. (MI-8901)
- Added user feedback when the projector search dialog is searching. (MI-8497)
- Added custom camera masking. (MI-9214)
- Added automatic discovery for Pandoras Box outputs. (MI-8956)
- Added the camera network view to Structured Light recalibrations. (MI-8724)
- Added the Christie 4K22-HS as a supported projector. (MI-9283)
- Added warnings when attempting to use multiple Pandoras Box managers. (MI-9190)
- Added an error message when attempting to select a measured screen that is the same as the content screen. (MI-9067)
- Added a table to the main view showing Structured Light camera calibration results. (MI-9238)
- Added a table in the calibration panel showing Structured Light camera calibration errors for each camera. (MI-9015)
- Added the ability for Mystique 3D to handle content of a different aspect ratio. (MI-9313, MI-9319)
- Added a warning to Black Level Blending preview to verify if the projector can be turned on or unshuttered. (MI-8935)


### Changed

- Changed Black Level Blending to no longer display black after rendering or preview. (MI-9166)
- Changed the default Mystique 3D Camera Calibration method to Structured Light. (MI-8600)
- Changed the camera view to resize automatically. (MI-6871)
- Changed channel names and channel values to be maintained upon projector replacement. (MI-8446)
- Ensured projector list order is used when performing Auto Exposure. (MI-8939, MI-8292)
- Ensured projector list order is maintained upon projector replacement. (MI-9174)
- Improved the runtime of Electronic Convergence. (MI-7229)
- Improved the cancellation time when generating a point cloud. (MI-9114)
- Improved visibility of camera models in the system view. (MI-8968)
- Improved structured light camera calibration error results. (MI-9252)
- Improved camera recalibration in Mystique 3D. (MI-9314)
- Improved the error message shown when enabling Guardian with no projector content. (MI-8200)
- Improved the contrast of checkboxes in Mystique Dark Mode. (MI-9235)
- Improved scroll bar interactions. (MI-9080, MI-9170)


### Fixed

- Addressed a crash while closing Mystique Lite while the camera was auto exposing. (MI-9104)
- Addressed a crash while closing Mystique Lite when no camera was selected. (MI-9066)
- Addressed a crash during Guided Setup. (MI-9036)
- Addressed a crash when attempting to use devices from multiple pandoras box managers at the same time. (MI-9000)
- Addressed a crash when selecting generic camera intrinsics. (MI-9333)
- Addressed a crash when searching for devices in Mystique Lite. (MI-9322)
- Addressed a crash when adding a projector. (MI-8975)
- Fixed an issue where a projector could be replaced with itself in Mystique Cinema. (MI-8936)
- Fixed an issue where projector controls were available when selecting multiple Pandoras Box outputs. (MI-8874)
- Fixed an issue that caused Scene Units to be ignored in Mystique 3D. (MI-7427)
- Addressed a crash when creating a new configuration file. (MI-9248)
- Fixed an issue that prevented the import of Maya files in Projector Centric layouts. (MI-7328)
- Fixed an issue where text was cut off in the Solver Override section of Projector Details. (MI-9041)
- Fixed an issue where unusable tabs were displayed under certain 3D workflows. (MI-9085)
- Fixed an issue that caused the view to change its layout when a camera was selected. (MI-9249)
- Fixed an issue that allowed Guardian Mode to be toggled when unsupported. (MI-9078)
- Fixed an issue that prevented alignment using manual camera exposure in Mystique Cinema. (MI-9076)
- Fixed an issue that caused the System View to be hidden upon opening Mystique. (MI-9057)
- Fixed an issue that changed the layout when replacing a projector. (MI-8485)
- Fixed an issue that allowed the user to send Color Uniformity adjustments when Color Uniformity was off. (MI-8919)
- Fixed an issue where the configuration panel in Mystique Cinema would have a black background. (MI-9121)
- Fixed an issue where using the shortcut to scale markers would enable the point cloud data. (MI-9277)
- Fixed an issue where there was a box around the 'Use Mask for Auto Exposure' option. (MI-9088)
- Fixed an issue where the MPCDI file was reporting the incorrect geometric unit. (MI-9150)
- Fixed an issue where a configuration file made with an older version of Mystique would no longer open. (MI-8444)
