# Changelog


## Mystique 2.11.2


### Added

- Added support for the Sapphire 4K40-RGBH projector. (MI-9969, MI-9997)


### Fixed

- Fixed an issue where some license dongles were not working. (MI-9911)
- Fixed an issue with being unable to draw the 3D Test Pattern when using custom output channel resolutions. (MI-9934) 
- Fixed an issue where the initial test pattern state of Cinema projectors would not be restored. (MI-10106)


## Mystique 2.11.1


### Fixed

- Fixed an issue where custom camera masking would not be used with runs triggered through Mystique Operate. (MI-9956)


## Mystique 2.11.0


### Added

- Added the ability to use Single Shot Automatic Exposure (beta). (MI-8353)
- Added a button to display the Single Shot Automatic Exposure Pattern (beta). (MI-9574)
- Added the ability to use Single Shot Gather (beta). (MI-7342)
- Added a button to display the Single Shot Gather Pattern (beta). (MI-7344)
- Added user feedback when loading an invalid screen model in 3D workflows. (MI-9485)
- Added Rest/JSON Operate API documentation to the installation folder. (MI-9444)
- Added the ability to maintain the camera name after a camera replace. (MI-9443)
- Added projector firmware version logging. (MI-9414)
- Added system load logging. (MI-9396)
- Added a copy of the marked surface image to diagnostics. (MI-9264)
- Added an image of the 2D gather validation test pattern to diagnostics. (MI-8782)
- Added the projector MAC address to projector details. (MI-8591)
- Added the ability to reorder cameras in the UI. (MI-5582)
- Added the Operate version number to the Operate webpages. (MO-79)


### Changed

- Improved license information logging. (MI-9399)
- Increased the maximum camera capture time to one second. (MI-9565)
- Improved image processing for better results when using colored test patterns. (MI-9521)
- Updated system requirements in the documentation. (MI-9494)
- Improved PNG writing performance. (MI-9434)
- Updated instructions for writing the MPCDI file to a network location. (MI-9409)
- Changed the color of the projector IP address to be more visible in dark mode. (MI-9403)
- Improved camera masking performance. (MI-9363)
- Improved Channel Width/Height input validation and tooltips. (MI-9344)
- Improved gather progress messages. (MI-9228)
- Improved webcam image capture perfomance. (MI-9039)
- Improved error message for connection issues during cinema alignments. (MI-8893)
- Changed Operate version number to now be the same as Mystique. (MO-77)
- Increased minimum command timeout of cinema projectors (MI-9701)
- Improved camera stability by reducing network contention (MI-9766)


### Fixed

- Fixed an issue where calibrations using a fisheye projector lens would not complete when ran with Mystique Operate. (MI-9638)
- Addressed a crash when closing Mystique when Guardian is enabled. (MI-9655)
- Fixed an issue where license dongles would not work. (MI-9603)
- Fixed an issue where changing the exposure of a Teledyne Dalsa Genie Nano camera was reporting failures in the logs. (MI-9569)
- Fixed an issue where the identify test pattern would draw incorrectly on some resolutions. (MI-9550)
- Addressed a crash when using the camera preview sharpness slider. (MI-9508)
- Addressed a crash when drawing the 3D wireframe test pattern through Operate. (MI-9502)
- Fixed an issue with excessive logging when using pandoras box outputs. (MI-9426)
- Fixed an issue where clicking a camera in the camera calibration table no longer auto selected that cameras preview and calibration table. (MI-9456)
- Fixed an issue where cinema autofocus would not find a good focus. (MI-9421)
- Addressed a crash that happened when the system runs out of memory/disk space. (MI-9379, MI-9335)
- Addressed a crash when removing a camera. (MI-9321)
- Fixed an issue where copying or saving camera preview images would not work. (MI-9316)
- Fixed an issue where switching preview layouts was changing the preview zoom level. (MI-9312)
- Fixed an issue where changing test patterns of many projectors at once was causing the UI to hang. (MI-9281)
- Addressed a crash when changing electronic convergence options after the camera has been removed. (MI-9141)
- Fixed an issue causing alignment failures while using high contrast mode and parallel gather. (MI-9046)
- Fixed an issue where cameras were listed as UNKNOWN in Mystique Lite. (MI-8987)
- Fixed an issue causing intermittent camera capture failures during cinema autofocus or electronic convergence runs. (MI-8405)
- Fixed an issue that showed the wrong Operate version number in Operate. (M0-81)
- Fixed an issue with incorrect filenames reported by the projector (MI-9700)

### Removed

- Removed Windows 8 as a supported operating system in the documentation. (MI-9495)


## Mystique 2.10.0


### Added

- Added the ability to do a partial gather with a subset of projectors in Mystique 3D. (MI-8788)
- Added a warning the Black Level % is set to less than the Tint %. (MI-8901)
- Added user feedback when the projector search dialog is searching. (MI-8497)
- Added custom camera masking. (MI-9214)
- Added automatic discovery for Pandoras Box outputs. (MI-8956)
- Added the camera network view to Structured Light recalibrations. (MI-8724)
- Added the Christie 4K22-HS as a supported projector. (MI-9283)
- Added warnings when attempting to use multiple Pandoras Box managers. (MI-9190)
- Added an error message when attempting to select a measured screen that is the same as the content screen. (MI-9067)
- Added a table to the main view showing Structured Light camera calibration results. (MI-9238)
- Added a table in the calibration panel showing Structured Light camera calibration errors for each camera. (MI-9015)
- Added the ability for Mystique 3D to handle content of a different aspect ratio. (MI-9313, MI-9319)
- Added a warning to Black Level Blending preview to verify if the projector can be turned on or unshuttered. (MI-8935)


### Changed

- Changed Black Level Blending to no longer display black after rendering or preview. (MI-9166)
- Changed the default Mystique 3D Camera Calibration method to Structured Light. (MI-8600)
- Changed the camera view to resize automatically. (MI-6871)
- Changed channel names and channel values to be maintained upon projector replacement. (MI-8446)
- Ensured projector list order is used when performing Auto Exposure. (MI-8939, MI-8292)
- Ensured projector list order is maintained upon projector replacement. (MI-9174)
- Improved the runtime of Electronic Convergence. (MI-7229)
- Improved the cancellation time when generating a point cloud. (MI-9114)
- Improved visibility of camera models in the system view. (MI-8968)
- Improved structured light camera calibration error results. (MI-9252)
- Improved camera recalibration in Mystique 3D. (MI-9314)
- Improved the error message shown when enabling Guardian with no projector content. (MI-8200)
- Improved the contrast of checkboxes in Mystique Dark Mode. (MI-9235)
- Improved scroll bar interactions. (MI-9080, MI-9170)


### Fixed

- Addressed a crash while closing Mystique Lite while the camera was auto exposing. (MI-9104)
- Addressed a crash while closing Mystique Lite when no camera was selected. (MI-9066)
- Addressed a crash during Guided Setup. (MI-9036)
- Addressed a crash when attempting to use devices from multiple pandoras box managers at the same time. (MI-9000)
- Addressed a crash when selecting generic camera intrinsics. (MI-9333)
- Addressed a crash when searching for devices in Mystique Lite. (MI-9322)
- Addressed a crash when adding a projector. (MI-8975)
- Fixed an issue where a projector could be replaced with itself in Mystique Cinema. (MI-8936)
- Fixed an issue where projector controls were available when selecting multiple Pandoras Box outputs. (MI-8874)
- Fixed an issue that caused Scene Units to be ignored in Mystique 3D. (MI-7427)
- Addressed a crash when creating a new configuration file. (MI-9248)
- Fixed an issue that prevented the import of Maya files in Projector Centric layouts. (MI-7328)
- Fixed an issue where text was cut off in the Solver Override section of Projector Details. (MI-9041)
- Fixed an issue where unusable tabs were displayed under certain 3D workflows. (MI-9085)
- Fixed an issue that caused the view to change its layout when a camera was selected. (MI-9249)
- Fixed an issue that allowed Guardian Mode to be toggled when unsupported. (MI-9078)
- Fixed an issue that prevented alignment using manual camera exposure in Mystique Cinema. (MI-9076)
- Fixed an issue that caused the System View to be hidden upon opening Mystique. (MI-9057)
- Fixed an issue that changed the layout when replacing a projector. (MI-8485)
- Fixed an issue that allowed the user to send Color Uniformity adjustments when Color Uniformity was off. (MI-8919)
- Fixed an issue where the configuration panel in Mystique Cinema would have a black background. (MI-9121)
- Fixed an issue where using the shortcut to scale markers would enable the point cloud data. (MI-9277)
- Fixed an issue where there was a box around the 'Use Mask for Auto Exposure' option. (MI-9088)
- Fixed an issue where the MPCDI file was reporting the incorrect geometric unit. (MI-9150)
- Fixed an issue where a configuration file made with an older version of Mystique would no longer open. (MI-8444)
